# Instruções:
# tome cuidado com indentação! Ela não determina se o bloco está dentro ou paralelo ao anterior
# para fazer x^{n}, onde n é a variável, faça x^{{{n}}}. 
# use sempre \(...\) em vez de $...$ para que o Moodle possa ler (desabilite TeX e habilite MathJax)
# compile o TeX gerado usando LuaLaTeX (por causa dos acentos) ou pdf+shell-escape para usar figuras
# tome cuidado com números com mais de 11 dígitos (calculadoras aproximam)
# avise os alunos que a resposta não deve conter pontos, vírgulas, etc.
# barras no nome do quiz geram sub-classes no Moodle (útil para organizar quizes)


import math             #importa a biblioteca matemática 

print(r"""\documentclass[12pt]{article}
\usepackage{moodle}
\usepackage{amsfonts,amssymb,amsmath,amsthm}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\moodleregisternewcommands
\begin{document}
\begin{quiz}{Integral ds}""")
for r in range(2,4):
    for k in range(r,3*r+1):
                resposta_problema = math.pi*r**3/k
                r2 = r*r
                print(rf"""\begin{{numerical}}[tolerance=0.01,points=1]{{Integral ds ({r},{k})}}\\
                    Calcule a \'area de uma cerca erguida sobre a circunfer\^encia \( C:x^2+y^2={r2}\), se sua altura em cada ponto for dada por \(h(x,y)=\frac{{x^2}}{{{k}}}\). D\^e a resposta com 2 casas decimais, usando V\'IRGULA.
                    \item {resposta_problema}
                    \end{{numerical}}""")
print(r"""\end{quiz}
\end{document}""")





