# Instruções:
# tome cuidado com indentação! Ela não determina se o bloco está dentro ou paralelo ao anterior
# para fazer x^{n}, onde n é a variável, faça x^{{{n}}}. 
# use sempre \(...\) em vez de $...$ para que o Moodle possa ler (desabilite TeX e habilite MathJax)
# compile o TeX gerado usando LuaLaTeX (por causa dos acentos) ou pdf+shell-escape para usar figuras
# tome cuidado com números com mais de 11 dígitos (calculadoras aproximam)
# avise os alunos que a resposta não deve conter pontos, vírgulas, etc.
# barras no nome do quiz geram sub-classes no Moodle (útil para organizar quizes)

  
import math             #importa a biblioteca matemática 

print(r"""\documentclass[12pt]{article}
\usepackage{moodle}
\usepackage{amsfonts,amssymb,amsmath,amsthm}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\moodleregisternewcommands
\newcommand\monomial[1]{x^{#1}}
\newcommand\besteira{O qu\^e!?}
\begin{document}
\begin{quiz}{Derivada}""")
for n in range(2,10):
    print(rf"""\begin{{multi}}[points=1]{{Derivada ({n})}}\\
Qual \'e a primeira derivada de \(f(x)=x^{{{n}}}\)?
\item\(x^{{{n+1}}}/{n+1}\)
\item[feedback={{Exato!}}]* \({n}x^{{{n-1}}}\)
\item[feedback={{\besteira}}] \(0\) 
\item  \(\frac{{x^{{{n-1}}}}}{{{n+1}}}\)
\item \(\int \frac{{x^{{{n}}}}}{{{n}}}dx\)
\end{{multi}}""")
print(r"""\end{quiz}
\end{document}""")


