# Instruções:
# tome cuidado com indentação! Ela não determina se o bloco está dentro ou paralelo ao anterior
# para fazer x^{n}, onde n é a variável, faça x^{{{n}}}. 
# use sempre \(...\) em vez de $...$ para que o Moodle possa ler (desabilite TeX e habilite MathJax)
# compile o TeX gerado usando LuaLaTeX (por causa dos acentos) ou pdf+shell-escape para usar figuras
# tome cuidado com números com mais de 11 dígitos (calculadoras aproximam)
# avise os alunos que a resposta não deve conter pontos, vírgulas, etc.
# barras no nome do quiz geram sub-classes no Moodle (útil para organizar quizes)


import math             #importa a biblioteca matemática 

print(r"""\documentclass[12pt]{article}
\usepackage{moodle}
\usepackage{amsfonts,amssymb,amsmath,amsthm}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\moodleregisternewcommands
\newcommand\monomial[1]{x^{#1}}
\begin{document}
\begin{quiz}{Carro, Moto, Onibus}""")
valor_maximo = 1e11 
for x in range(4,8):
    for y in range(4,8):
            for z in range(4,8): 
                resposta_problema = int(math.factorial(x)*math.factorial(y)*math.factorial(z))
                if resposta_problema  < valor_maximo:   
                    print(rf"""\begin{{numerical}}[points=1]{{Carro, Moto, Onibus ({x},{y},{z})}}\\
De quantas maneiras podemos fazer uma fila com \({x}\) carros seguidos de \({y}\) motos, seguidas de \({z}\) \^onibus?
\item {resposta_problema}
\end{{numerical}}""")
print(r"""\end{quiz}
\end{document}""")





